/**
 * RAPID SERVICE CONNECT - ENTERPRISE SEO TEMPLATE SYSTEM
 * =========================================================
 */

const fs = require('fs');
const path = require('path');

// Load data
const services = require('../data/services.json');
const cities = require('../data/cities.json');
const blogArticles = require('../data/blog-articles.json');

/**
 * Generate FAQ Schema
 */
function generateFAQSchema(faqs) {
  const faqItems = faqs.map(faq => ({
    "@type": "Question",
    "name": faq.question,
    "acceptedAnswer": {
      "@type": "Answer",
      "text": faq.answer
    }
  }));

  return `<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": ${JSON.stringify(faqItems, null, 2)}
}
</script>`;
}

function generateHowToSchema(name, steps) {
  const stepItems = steps.map((step, idx) => ({
    "@type": "HowToStep",
    "position": idx + 1,
    "name": step.name,
    "text": step.text
  }));

  return `<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "HowTo",
  "name": "${name}",
  "step": ${JSON.stringify(stepItems, null, 2)}
}
</script>`;
}

function generateLocalBusinessSchema(serviceName, cityName, cityState) {
  return `<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Service",
  "serviceType": "${serviceName}",
  "provider": {
    "@type": "Organization",
    "name": "Rapid Service Connect",
    "url": "http://rapidserviceconnect.com"
  },
  "areaServed": {
    "@type": "City",
    "name": "${cityName}",
    "containedInPlace": {
      "@type": "State",
      "name": "${cityState}"
    }
  },
  "availableChannel": {
    "@type": "ServiceChannel",
    "serviceUrl": "http://rapidserviceconnect.com",
    "availableLanguage": "en-US"
 }
}
</script>`;
}

function generateBreadcrumbSchema(breadcrumbs) {
  const items = breadcrumbs.map((crumb, idx) => ({
    "@type": "ListItem",
    "position": idx + 1,
    "name": crumb.name,
    "item": `http://rapidserviceconnect.com${crumb.url}`
  }));

  return `<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": ${JSON.stringify(items, null, 2)}
}
</script>`;
}

function getHeader() {
  return `<!DOCTYPE html>
<html lang="en-US">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
  <link rel="stylesheet" href="/css/chatbot.css">`;
}

function getNavigation(services, cities) {
  // Group services for 4-column mega menu
  const emergencyCore = services.filter(s =>
    ['plumbing', 'hvac', 'electrical', 'water-damage', 'towing', 'roofing'].includes(s.id)
  );
  const exteriorServices = services.filter(s =>
    ['windows', 'gutters', 'pest-control', 'concrete', 'tree-removal', 'lawn-care'].includes(s.id)
  );
  const interiorServices = services.filter(s =>
    ['mold', 'appliance', 'garage-door', 'flooring', 'security'].includes(s.id)
  );
  const remodelingRentals = services.filter(s =>
    ['bathroom-remodel', 'kitchen-remodel', 'walk-in-tubs', 'solar', 'portable-toilets', 'dumpsters'].includes(s.id)
  );

                  </div >
                  <div class="mega-menu-column">
                    <h4>🟦 Exterior Services</h4>
                    <ul class="mega-menu-links">
                      ${exteriorServices.map(s => `<li><a href="/services/${s.slug}/">${s.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                  <div class="mega-menu-column">
                    <h4>🟩 Interior Services</h4>
                    <ul class="mega-menu-links">
                      ${interiorServices.map(s => `<li><a href="/services/${s.slug}/">${s.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                  <div class="mega-menu-column">
                    <h4>🟨 Remodeling & Rentals</h4>
                    <ul class="mega-menu-links">
                      ${remodelingRentals.map(s => `<li><a href="/services/${s.slug}/">${s.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                </div >
    <div class="mega-menu-cta">
      <div class="mega-menu-cta-text">
        Can't find your service?
        <small>We'll instantly route you to the right professional.</small>
      </div>
      <a href="/contact/" class="mega-menu-cta-btn">📞 Call Now</a>
    </div>
              </div >
            </div >
          </li >
          
          <li class="nav-item has-mega-menu">
            <a href="#" class="nav-link">Top Cities</a>
            <div class="mega-menu cities-mega-menu">
              <div class="mega-menu-container">
                <div class="mega-menu-grid">
                  <div class="state-group state-texas">
                    <h4>🟥 Texas</h4>
                    <ul class="mega-menu-links">
                      ${texasCities.map(c => `<li><a href="/cities/${c.slug}/">${c.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                  <div class="state-group state-florida">
                    <h4>🟦 Florida</h4>
                    <ul class="mega-menu-links">
                      ${floridaCities.map(c => `<li><a href="/cities/${c.slug}/">${c.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                  <div class="state-group state-california">
                    <h4>🟩 California</h4>
                    <ul class="mega-menu-links">
                      ${californiaCities.map(c => `<li><a href="/cities/${c.slug}/">${c.name}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                  <div class="state-group state-other">
                    <h4>🟨 Other Major Cities</h4>
                    <ul class="mega-menu-links">
                      ${otherCities.map(c => `<li><a href="/cities/${c.slug}/">${c.name}, ${c.state}</a></li>`).join('\n                      ')}
                    </ul>
                  </div>
                </div>
                <div class="mega-menu-footer">
                  <a href="/cities/">View All 60 Cities →</a>
                </div>
              </div>
            </div>
          </li>
          
          <li class="nav-item"><a href="/blog/" class="nav-link">Resources</a></li>
          <li class="nav-item"><a href="/contact/" class="nav-link">Contact</a></li>
        </ul >
      </nav >
    </div >
  </header > `;
}

function getFooter(services, cities) {
  const topCities = cities.slice(0, 20);

  return `< footer class="site-footer" role = "contentinfo" >
    <div class="container">
      <div class="footer-content">
        <div class="footer-column">
          <h4>Company</h4>
          <ul class="footer-links">
            <li><a href="/about/">About Us</a></li>
            <li><a href="/how-it-works/">How It Works</a></li>
            <li><a href="/contact/">Contact</a></li>
          </ul>
        </div>
        <div class="footer-column">
          <h4>Emergency Services</h4>
          <ul class="footer-links">
            ${services.slice(0, 8).map(s => `<li><a href="/services/${s.slug}/">${s.name}</a></li>`).join('\n            ')}
          </ul>
        </div>
        <div class="footer-column">
          <h4>More Services</h4>
          <ul class="footer-links">
            ${services.slice(8, 16).map(s => `<li><a href="/services/${s.slug}/">${s.name}</a></li>`).join('\n            ')}
          </ul>
        </div>
        <div class="footer-column">
          <h4>Top Cities</h4>
          <ul class="footer-links">
            ${topCities.slice(0, 10).map(c => `<li><a href="/cities/${c.slug}/">${c.name}, ${c.state}</a></li>`).join('\n            ')}
          </ul>
        </div>
        <div class="footer-column">
          <h4>Legal</h4>
          <ul class="footer-links">
            <li><a href="/disclaimer/">Disclaimer</a></li>
            <li><a href="/privacy-policy/">Privacy Policy</a></li>
            <li><a href="/terms/">Terms of Use</a></li>
          </ul>
        </div>
      </div>
      <div class="footer-disclaimer">
        <p><strong>Important Disclaimer:</strong> Rapid Service Connect is an independent referral service connecting consumers with third-party service providers. We do not directly provide plumbing, HVAC, electrical, towing, or any other services. All service providers are independent professionals. Availability and response times may vary by location. Calls may be recorded for quality and compliance purposes.</p>
      </div>
      <div class="footer-bottom">
        <p>&copy; ${new Date().getFullYear()} Rapid Service Connect. All rights reserved.</p>
      </div>
    </div>
  </footer >
  <script src="/js/chatbot.js"></script>
  <script src="/js/main.js"></script>
</body >
</html > `;
}

function getDisclaimer() {
  return `< aside class="disclaimer" role = "complementary" aria - label="Service disclaimer" >
    <h4>Disclaimer:</h4>
    <p>
      Rapid Service Connect is an independent referral service that connects consumers with third-party service providers. 
      We do not directly provide plumbing, HVAC, electrical, towing, or restoration services. All service providers are 
      independent professionals. Availability and response times may vary by location. Calls may be recorded for quality 
      and compliance purposes.
    </p>
  </aside > `;
}

module.exports = {
  generateFAQSchema,
  generateHowToSchema,
  generateLocalBusinessSchema,
  generateBreadcrumbSchema,
  getHeader,
  getNavigation,
  getFooter,
  getDisclaimer,
  services,
  cities,
  blogArticles
};

