const fs = require('fs');
const path = require('path');

// Emoji mappings for each service
const emojiMappings = {
    'towing-premium.json': [
        { title: 'Emergency Towing (Flatbed & Wheel Lift)', emoji: '🚛' },
        { title: 'Dead Battery Jump Starts', emoji: '🔋' },
        { title: 'Flat Tire Changes', emoji: '🛞' },
        { title: 'Car Lockout Service', emoji: '🔑' },
        { title: 'Fuel Delivery', emoji: '⛽' },
        { title: 'Winch-Out & Recovery', emoji: '⚙️' },
        { title: 'Accident Recovery', emoji: '💥' },
        { title: 'Motorcycle Towing', emoji: '🏍️' },
        { title: 'Long-Distance Towing', emoji: '🗺️' },
        { title: 'Heavy Duty Towing', emoji: '🚚' }
    ],
    'electrical-premium.json': [
        { title: 'Sudden power outages (not utility-related)', emoji: '⚡' },
        { title: 'Sparking or smoking outlets and switches', emoji: '⚠️' },
        { title: 'Burning plastic or fishy smells', emoji: '👃' },
        { title: 'Circuit breakers tripping repeatedly', emoji: '🔌' },
        { title: 'Flickering or dimming lights', emoji: '💡' },
        { title: 'Electrical shocks from appliances or fixtures', emoji: '⚡' },
        { title: 'Buzzing or humming sounds from breaker panels', emoji: '🔊' },
        { title: 'Storm damage to electrical service', emoji: '🌩️' },
        { title: 'Wet or flooded electrical panels', emoji: '💧' },
        { title: 'Generator failure during outages', emoji: '🔋' }
    ],
    'water-damage-premium.json': [
        { title: 'Burst Pipes and Frozen Plumbing', emoji: '💧' },
        { title: 'Sewer Line Backups', emoji: '🚽' },
        { title: 'Storm and Flood Damage', emoji: '🌊' },
        { title: 'Appliance Leaks (Washer/Dishwasher/Heater)', emoji: '🔧' },
        { title: 'Firefighting Water Damage', emoji: '🚒' },
        { title: 'Toilet Overflows', emoji: '🚰' },
        { title: 'Sump Pump Failures', emoji: '⚙️' },
        { title: 'Roof Leaks and Ceiling Collapse', emoji: '🏚️' },
        { title: 'Foundation Seepage', emoji: '🧱' },
        { title: 'Mold Remediation', emoji: '🦠' }
    ]
};

// Process each file
Object.keys(emojiMappings).forEach(filename => {
    const filePath = path.join(__dirname, 'content', 'services', filename);

    // Read the file
    const content = fs.readFileSync(filePath, 'utf8');
    const data = JSON.parse(content);

    // Add emojis to problems
    if (data.sections && data.sections.commonProblems && data.sections.commonProblems.problems) {
        data.sections.commonProblems.problems.forEach(problem => {
            const mapping = emojiMappings[filename].find(m => m.title === problem.title);
            if (mapping && !problem.emoji) {
                problem.emoji = mapping.emoji;
            }
        });
    }

    // Write back with proper formatting
    fs.writeFileSync(filePath, JSON.stringify(data, null, 4), 'utf8');
    console.log(`✅ Updated ${filename}`);
});

console.log('\n🎉 All emojis added successfully!');
